//========================================================================
//	Acquire.h
//	Copyright 1995 - 1996 Metrowerks Corporation, All Rights Reserved.
//========================================================================	

#pragma once

/*
 * This very useful class helps cleaning up when acquiring
 * semaphores. It works great with exceptions, as well.
 * To use, make sure to call Acquire::OpenAcquire() before
 * any Acquire object is created. Call Acquire::CloseAcquire()
 * when all Acquire objects are gone, before exiting.
 * To acquire a semaphore, just create an object on the stack:
 *
 * void protected_func() {
 *		Acquire lock(protect_semaphore);
 *		if (!lock)
 *			invalid_semaphore(protect_semaphore);
 *		... code goes here ...
 * }
 */

#include <OS.h>


class Acquire
{
	struct SemStruct
	{
			SemStruct *				fNext;
			sem_id					fSem;
			thread_id				fThread;
			Acquire *				fAcquired;
	};
static	SemStruct *				sSemStructs;
static	sem_id					sStructSem;

		Acquire *				fNext;
		SemStruct *				fHead;

public:
								Acquire(
									sem_id sem,
									const char * ptr = NULL);
								~Acquire();

static	long					OpenAcquire();
static	void					CloseAcquire();

								operator!() { return fHead == NULL; }
};


